TFCServerSystem = {}
TFCServerSystem.tfcCommands = {}

local TFC_Utils = require("TABAS_TFCSystem_Utils")

function TFCServerSystem.tfcCommands.Register(player, args)
    local gData = GetTFCSystemData()
    local id = TFC_Utils.getIdByCoords(args.x, args.y, args.z)
    gData.Registered[id] = args
end

function TFCServerSystem.tfcCommands.Unregister(player, args)
    local gData = GetTFCSystemData()
    local id = TFC_Utils.getIdByCoords(args.x, args.y, args.z)
    gData.Registered[id] = nil
end

function TFCServerSystem.tfcCommands.dataUpdate(player, args)
    local gData = GetTFCSystemData()
    local id = TFC_Utils.getIdByCoords(args.x, args.y, args.z)
    if not gData.Registered[id] then return end
    for k,v in pairs(args) do
        gData.Registered[id][k] = v
    end
end

function TFCServerSystem.tfcCommands.Activated(player, args)
    local gData = GetTFCSystemData()
    local id = TFC_Utils.getIdByCoords(args.x, args.y, args.z)
    if gData.Activated[id] then
        for k,v in pairs(args) do
            gData.Activated[id][k] = v
        end
    else
        gData.Activated[id] = args
    end
end

function TFCServerSystem.tfcCommands.ActivatedClear(player, args)
    local gData = GetTFCSystemData()
    local id = TFC_Utils.getIdByCoords(args.x, args.y, args.z)
    if gData.Activated[id] then
        if gData.Activated[id].emitter then
            gData.Activated[id].emitter:stopAll()
            gData.Activated[id].emitter = nil
        end
        gData.Activated[id] = nil
    end
end

function TFCServerSystem.tfcCommands.RegistPendedRemove(player, args)
    local gData = GetTFCSystemData()
    local id = TFC_Utils.getIdByCoords(args.x, args.y, args.z)
    gData.PendedRemove[id] = args
end

function TFCServerSystem.tfcCommands.UnregistPendedRemove(player, args)
    local gData = GetTFCSystemData()
    local id = TFC_Utils.getIdByCoords(args.x, args.y, args.z)
    gData.PendedRemove[id] = nil
end

local function onClientCommand(module, command, player, args)
	if TFCServerSystem[module] and TFCServerSystem[module][command] then
		local argStr = ''
		for k,v in pairs(args) do 
            argStr = argStr .. ' ' .. k .. '=' .. tostring(v)
        end
        TFCServerSystem[module][command](player, args)
        TFCSystemTransmit()
	end
end

Events.OnClientCommand.Add(onClientCommand)